package row_data_gateway;
import db_context.DbContext;

import java.math.BigDecimal;
import java.sql.*;

public class Driver {
    private Integer id;
    private String first_name;
    private String second_name;
    private Date hire_date;
    private BigDecimal salary;
    private BigDecimal initial_salary;
    private Integer delivered_packages;
    private Integer location_id;
    private Integer transport_id;

    public Integer getId() { return id; }
    public void setId(Integer id) { this.id = id; }

    public String getFirst_name() { return first_name; }
    public void setFirst_name(String first_name) { this.first_name = first_name; }

    public String getSecond_name() { return second_name; }
    public void setSecond_name(String second_name) { this.second_name = second_name; }

    public Date getHire_date() { return hire_date; }
    public void setHire_date(Date hire_date) { this.hire_date = hire_date; }

    public BigDecimal getInitial_salary() { return initial_salary; }
    public void setInitial_salary(BigDecimal initial_salary) { this.initial_salary = initial_salary; }

    public BigDecimal getSalary() { return salary; }
    public void setSalary(BigDecimal salary) { this.salary = salary; }

    public Integer getDelivered_packages() { return delivered_packages; }
    public void setDelivered_packages(Integer delivered_packages) { this.delivered_packages = delivered_packages; }

    public Integer getLocation_id() { return location_id; }
    public void setLocation_id(Integer location_id) { this.location_id = location_id; }

    public Integer getTransport_id() { return transport_id; }
    public void setTransport_id(Integer transfer_id) { this.transport_id = transfer_id; }

    public void insert() throws SQLException {
        try (PreparedStatement s = DbContext.getConnection().prepareStatement("INSERT INTO drivers (first_name, second_name, hire_date, salary, initial_salary, delivered_packages, location_id, transport_id) VALUES (?,?,?,?,?,?,?,?)", Statement.RETURN_GENERATED_KEYS)) {
            s.setString(1, first_name);
            s.setString(2, second_name);
            //s.setDate(3, hire_date);
            s.setDate(3, new Date(System.currentTimeMillis()));
            //s.setBigDecimal(4, salary);
            s.setBigDecimal(4, new BigDecimal(1000));
            s.setBigDecimal(5, new BigDecimal(1000));
            //s.setInt(5, delivered_packages);
            s.setInt(6, 0);
            s.setInt(7, location_id);
            //s.setInt(7, transport_id);
            s.setNull(8, java.sql.Types.INTEGER);
            s.executeUpdate();

            try (ResultSet r = s.getGeneratedKeys()) {
                r.next();
                id = r.getInt(1);
            }
        }
    }

    public void update() throws SQLException {
        if (id == null) {
            throw new IllegalStateException("id is not set");
        }

        try (PreparedStatement s = DbContext.getConnection().prepareStatement("UPDATE drivers SET first_name = ?, second_name = ?, hire_date = ?, salary = ?, initial_salary = ?, delivered_packages = ?, location_id = ?, transport_id = ? WHERE id = ?")) {
            s.setString(1, first_name);
            s.setString(2, second_name);
            s.setDate(3, hire_date);
            s.setBigDecimal(4, salary);
            s.setBigDecimal(5, initial_salary);
            s.setInt(6, delivered_packages);
            s.setInt(7, location_id);
            if(transport_id == null) s.setNull(8, java.sql.Types.INTEGER);
            else s.setInt(8, transport_id);

            s.setInt(9, id);
            s.executeUpdate();
        }
    }

    public void delete() throws SQLException {
        if (id == null) {
            throw new IllegalStateException("id is not set");
        }

        try (PreparedStatement s = DbContext.getConnection().prepareStatement("DELETE FROM drivers WHERE id = ?")) {
            s.setInt(1, id);
            s.executeUpdate();
        }
    }
}
